package com.youqian.api.dto.shop;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 库存量订单关联
 * @author youqian mybatis generator 
 * 2020-03-31
 */
@Data
public class ShopSkuOrderDto implements Serializable {
    private static final long serialVersionUID = 1585651345703160L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopSkuOrderId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 库存量id
     * not null default = null
     */
    private Long skuId;

    /**
     * 订单id
     * not null default = null
     */
    private Long orderid;

    /**
     * 订购数量
     * not null default = null
     */
    private Integer total;

    /**
     * 订购总价
     * not null default = null
     */
    private BigDecimal totalPrice;

    /**
     * 订购单价
     * not null default = null
     */
    private BigDecimal price;
}