package com.youqian.api.dto.shopgoods;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 商品sku表详细内容介绍
 * @author youqian mybatis generator 
 * 2021-02-21
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ShopGoodsIntroductionDto implements Serializable {
    private static final long serialVersionUID = 16138884660959366L;

    private Long id;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Boolean deleted;

    /**
     * 商品id
     * not null default = 0
     */
    private Long shopGoodsId;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopGoodsSkuId;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 富文本说明介绍
     * not null default = null
     */
    private String introduction;
}