package com.youqian.api.dto.sign;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户实名信息表
 * @author youqian mybatis generator 
 * 2020-04-03
 */
@Data
public class DtoAuthDto implements Serializable {
    private static final long serialVersionUID = 15859033217933475L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 主体实名Id
     */
    private Long entityAuthId;

    /**
     * 签约主体ID
     * not null default = 0
     */
    private Long signEntityId;

    /**
     * 个人证件号码（个人属性）
     * max length = 100
     * not null default = 
     */
    private String userIdentity;

    /**
     * 证件类型（个人属性）
     * not null default = 0
     */
    private Byte identityType;

    /**
     * 真实名称（个人姓名/企业名称）
     * max length = 100
     * not null default = 
     */
    private String realName;

    /**
     * 身份证正面
     * max length = 100
     * not null default = 
     */
    private String idcardFront;

    /**
     * 身份证反面
     * max length = 100
     * not null default = 
     */
    private String idcardBack;

    /**
     * 手机号码/账号（个人属性）
     * max length = 20
     * not null default = 
     */
    private String mobile;

    /**
     * 营业执照（企业属性）
     * max length = 50
     * not null default = 
     */
    private String regCode;

    /**
     * 税务登记证（企业属性）
     * max length = 50
     * not null default = 
     */
    private String taxCode;

    /**
     * 组织架构代码（企业属性）
     * max length = 50
     * not null default = 
     */
    private String orgCode;

    /**
     * 营业执照图片
     * max length = 100
     * not null default = 
     */
    private String regImage;

    /**
     * 法人（企业属性）
     * max length = 20
     * not null default = 
     */
    private String legalPerson;

    /**
     * 法人证件信息（企业属性）
     * max length = 100
     * not null default = 
     */
    private String legalPersonIdentity;

    /**
     * 法人证件类型（企业属性）
     * not null default = 0
     */
    private Byte legalPersonIdentityType;

    /**
     * 法人手机号码（企业属性）
     * max length = 20
     * not null default = 
     */
    private String legalPersonMobile;

    /**
     * 法人身份证正面
     * max length = 100
     * not null default = 
     */
    private String legalIdcardFront;

    /**
     * 法人身份证反面
     * max length = 100
     * not null default = 
     */
    private String legalIdcardBack;

    /**
     * 上上签账户
     * max length = 100
     * not null default = 
     */
    private String ssqAccount;

    /**
     * 证书编号
     * max length = 100
     * not null default = 
     */
    private String certNo;

    /**
     * ssq申请证书taskId
     * max length = 100
     * not null default = 
     */
    private String taskId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}