package com.youqian.api.dto.sign;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 签约主体表（租户和用户或者企业的绑定关系）
 * @author youqian mybatis generator 
 * 2020-04-03
 */
@Data
public class SignDtoDto implements Serializable {
    private static final long serialVersionUID = 15859023319267199L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 签约主体Id
     */
    private Long signEntityId;

    /**
     * 所属商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 1-个人，2-企业
     * not null default = 0
     */
    private Byte entityType;

    /**
     * 0-正常，1-停用
     * not null default = 0
     */
    private Byte entityStatus;

    /**
     * 实名状态，0-未实名，1-实名中，2-实名完成，3-实名被驳回
     * not null default = 0
     */
    private Byte authStatus;

    /**
     * 名称, 企业名称或者个人名称
     * max length = 100
     * not null default = 
     */
    private String entityName;

    /**
     * 责任人
     * not null default = 0
     */
    private Long userId;

    /**
     * 负责人手机号码
     * max length = 20
     * not null default = 
     */
    private String mobile;

    /**
     * 负责人名称
     * max length = 100
     * not null default = 
     */
    private String userName;

    /**
     * 签章图片
     * max length = 100
     * not null default = 
     */
    private String seal;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}