package com.youqian.api.dto.survey;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 问卷题目
 * @author youqian mybatis generator 
 * 2021-01-13
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SurveyQuestionDto implements Serializable {
    private static final long serialVersionUID = 16105255679256952L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long surveyQuestionId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 问卷id
     * not null default = 0
     */
    private Long surveyId;

    /**
     * 排序号
     * not null default = 0
     */
    private Integer displayOrder;

    /**
     * 题目名称
     * max length = 255
     * not null default = 
     */
    private String itemTitle;

    /**
     * 题目类型 1：单选项目 2：多选项目 3：文本项目 
     * not null default = 1
     */
    private Integer itemType;
}