package com.youqian.api.dto.wms;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Sku件规表
 * @author youqian mybatis generator 
 * 2020-10-26
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DozenDto implements Serializable {
    private static final long serialVersionUID = 16037007112411388L;

    /**
     * 自动正常id
     * not null default = null
     */
    private Long id;

    /**
     * 件规id
     * not null default = null
     */
    private Long dozenId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtMoified;

    /**
     * 是否删除 0-否 1-已删除
     * not null default = 0
     */
    private Boolean deleted;

    /**
     * 商品规格
     * not null default = null
     */
    private Integer goodsSpec;

    /**
     * 包装规格
     * not null default = 0
     */
    private Integer packageSpec;

    /**
     * 件规名称
goods_spec*package_spec
     * max length = 50
     * not null default = null
     */
    private String dozenName;

    /**
     * 库存数量
     * not null default = 0
     */
    private Integer totalQuantity;

    /**
     * 可用库存数量
     * not null default = 0
     */
    private Integer availableQuantity;

    /**
     * 已售商品数量
     * not null default = 0
     */
    private Integer soldQuantity;

    /**
     * 体积
     * not null default = null
     */
    private BigDecimal dozenCubage;

    /**
     * 重量
     * not null default = null
     */
    private BigDecimal dozenWeight;

    /**
     * 商品skuid
     * not null default = 0
     */
    private Long shopGoodsSkuId;
}