package com.youqian.api.echarts.data;

import com.youqian.api.echarts.style.ItemStyle;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 饼图
 *
 * Created by hong
 * time 2020/11/18.
 */
@Getter
@Setter
public class PieData implements Serializable {

    private static final long serialVersionUID = -2573889018261931162L;

    private Object value;
    private String name;
    private ItemStyle itemStyle;

    /**
     * 构造函数,参数:name,value
     *
     * @param name
     * @param value
     */
    public PieData(String name, Object value) {
        this.value = value;
        this.name = name;
    }

    /**
     * 获取value值
     */
    public Object value() {
        return this.value;
    }

    /**
     * 设置value值
     *
     * @param value
     */
    public PieData value(Object value) {
        this.value = value;
        return this;
    }
}
