package com.youqian.api.enums;

import lombok.Getter;

/**
 * @author xiachenhang
 */
@Getter
public enum ActionEnum {
    /**
     * 线索
     */
    UN_KNOW((byte)0,"un_know","","","",""),
    FOLLOW((byte)1,"follow","关注了","店铺名片","关注了店铺",""),
    COLLECTION((byte)2,"collection","收藏了","商品","收藏了商品","#%s#"),
    ENQUIRY((byte)3,"enquiry","询价了","商品","",""),
    COME_IN_STORE((byte)4,"comeIn","查看了","店铺名片","进入店铺",""),
    COME_IN_STORE_PHOTO((byte)5,"comeIn","看了","商品","看了商品","#%s#"),
    COME_IN_LIVE_ROOM((byte)6,"comeLiveRoom","进入了","直播间","正在观看直播","#%s#"),
    RESERVE_LIVE_ROOM((byte)7,"reserveLiveRoom","订阅了","直播间","订阅了直播","#%s#"),
    COME_IN_UN_START_LIVE_ROOM((byte)8,"comeUnStartLiveRoom","进入了","直播预告","进入了直播预告","#%s#"),
    SHARE_USER_CHURN((byte)9,"","","","",""),
    ADD_ORDER_BILL((byte)10,"addOrderBill","加入了","进货单","加入了进货单","将商品#%s#加入了进货单"),
    CONFIRM_ORDER_BILL((byte)11,"confirmOrderBill","提交了","进货单","提交了进货单","含%s款,共%s件商品"),
    SUB_NEXT_LIVE((byte)12,"subNextLive","订阅了","下场直播","订阅了下场直播",""),
    RECORD_LIVE((byte)13,"recordLive","看了","回放","看了回放","#%s#"),
    SHORT_VIDEO((byte)14,"shortVideo","看了","短视频","看了短视频","#%s#"),
    ;

    private byte code;
    private String data;
    private String type;
    private String channel;
    private String behavior;
    private String remark;

    ActionEnum(byte code,String data, String type,String channel,String behavior,String remark){
        this.data = data;
        this.code = code;
        this.type = type;
        this.channel = channel;
        this.behavior = behavior;
        this.remark = remark;
    }

    public static ActionEnum get(Byte code){
        if(code == null){
            return UN_KNOW;
        }
        for(ActionEnum action:values()){
            if(action.getCode() == code){
                return action;
            }
        }
        return UN_KNOW;
    }

}
