package com.youqian.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

@Getter
public enum AliErrorCode {
    UN_ERROR(399,"阿里云未录入异常"),
    INVALID_URL(400,"URL错误"),
    FORBIDDEN(403,"没有购买，或者购买次数用尽，或者URL错误"),
    REQUEST_TIMEOUT	(408,"超时"),
    PAYLOAD_TOO_LARGE(413,"后端服务队列满，请求被拒绝，重试即可"),
    TRY_AGAIN(450,"URL错误"),
    FAILED_TO_PARSE_JSON(460,"上传的body不符合json格式要求，是非法json"),
    INVALID_INPUT(461,"输入Json中的image值不是字符串"),
    IMAGE_DATA_ERROR(462,"从URL下载图像失败"),
    WRONG_CATEGORY(463,"输入图像不是对应服务的图像，如行驶证服务请求的不是行驶证"),
    INVALID_RESULT(464,"识别失败,请摆正照片"),
    INVALID_SERVICE(469,"内部异常"),
    BAD_GATEWAY(502,"识别程序超时并断开连接"),
    SERVICE_UNAVAILABLE	(503,"API网关等待超时断开连接");

    private Integer code;
    private String type;

    AliErrorCode(Integer code,String type){
        this.code = code;
        this.type = type;
    }

    public static AliErrorCode getByType(Integer code){
        return Stream.of(AliErrorCode.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(UN_ERROR);
    }
}
