package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/3/30
 * @description 是否是部门管理员
 */
@Getter
public enum EnumOrgAdmin {

    NOT_ORG_ADMIN((byte) 0, "不是部门管理员"),
    ORG_ADMIN((byte) 1, "部门管理员"),
    ;

    private final Byte code;

    /**
     * 送货描述
     */
    private final String desc;

    EnumOrgAdmin(Byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isOrgAdmin(Byte code) {
        return Objects.equals(code, ORG_ADMIN.code);
    }


}
