package com.youqian.api.enums;

import lombok.Getter;

/**
 * @author tengtuox
 * @date 2020/3/30
 * @description 送货类型
 */
@Getter
public enum EnumTransFeeType {

    UNKNOWN((byte) 0, "未知"),
    PAY_FIRST((byte) 1, "预付运费"),
    NO_MONEY((byte) 2, "包邮"),
    GET_THEN_PAY((byte) 3, "到付");

    private final Byte code;

    /**
     * 送货描述
     */
    private final String desc;

    EnumTransFeeType(Byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }


}
