package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/3/30
 * @description 送货类型
 */
@Getter
public enum EnumTransType {

    UNKNOWN((byte) 0, "未知"),
    Delivery_Home((byte) 1, "卖方送货上门"),
    Self_Get((byte) 2, "买家自提"),
    Logistics_Delivery((byte) 3, "物流发货"),
    ;

    private final Byte code;

    /**
     * 送货描述
     */
    private final String desc;

    EnumTransType(Byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isSend(Byte code) {
        return Objects.equals(code, Delivery_Home.code) || Objects.equals(code, Logistics_Delivery.code);
    }

    public static boolean isGet(Byte code) {
        return Objects.equals(code, Self_Get.code);
    }


}
