package com.youqian.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 收入或支出枚举
 * Created by hong
 * time 2020/7/17.
 */
@Getter
public enum IncomeOrExpensesEnum {

    INCOME((byte)1,"income","收入"),
    EXPENSES((byte)2,"dxpenses","支出");

    private final Byte code;

    private final String type;

    private final String desc;

    IncomeOrExpensesEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static IncomeOrExpensesEnum getByCode(Byte code) {
        return Stream.of(IncomeOrExpensesEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(INCOME);
    }

    public static IncomeOrExpensesEnum getByType(String type) {
        return Stream.of(IncomeOrExpensesEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(INCOME);
    }
}

