package com.youqian.api.enums;

import com.google.common.base.Objects;
import lombok.Getter;

@Getter
public enum OrderInvalidStatus {
    UN_KNOW((byte)-1,"异常"),
    NORMAL((byte)0,"正常"),
    OTHER_INVALID((byte)1,"部分失效"),
    ALL_INVALID((byte)2,"全部失效"),
    ;

    private Byte code;
    private String msg;

    OrderInvalidStatus(Byte code,String msg){
        this.code = code;
        this.msg  = msg;
    }

    public static String getMsg(Byte code){
        for(OrderInvalidStatus o:values()){
            if(Objects.equal(code,o.getCode())){
                return o.getMsg();
            }
        }
        return "";
    }
}
