package com.youqian.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2021/1/13.
 */
@Getter
public enum SurveyTypeEnum {

    LIVE(1, "live", "直播或回放问卷");

    private final Integer code;

    private final String  type;

    private final String  desc;

    SurveyTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static SurveyTypeEnum getByCode(Integer code) {
        return Stream.of(SurveyTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(LIVE);
    }

    public static SurveyTypeEnum getByType(String type) {
        return Stream.of(SurveyTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(LIVE);
    }
}