package com.youqian.api.enums.customer;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/8/18.
 */
@Getter
public enum CustomerGenderEnum {

    UNKNOWN((byte)0,"unknown","未知"),
    MALE((byte)1,"male","男"),
    FEMALE((byte)2,"female","女"),;

    private final Byte code;

    private final String type;

    private final String desc;

    CustomerGenderEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static CustomerGenderEnum getByCode(Byte code) {
        return Stream.of(CustomerGenderEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(UNKNOWN);
    }

    public static CustomerGenderEnum getByType(String type) {
        return Stream.of(CustomerGenderEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(UNKNOWN);
    }
}

