package com.youqian.api.enums.customer;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/8/11.
 */
@Getter
public enum CustomerLabelLevelEnum {

    NOT_LEVEL(-1,"notLevel","非固定标签"),
    VISITORS(0,"visitors","访客"),
    GENERAL(1,"general","一般客户"),
    MAJOR(2,"major","重要客户"),
    CORE(3,"core","核心客户");

    private final Integer code;

    private final String type;

    private final String desc;

    CustomerLabelLevelEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static CustomerLabelLevelEnum getByCode(Integer code) {
        return Stream.of(CustomerLabelLevelEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(NOT_LEVEL);
    }

    public static CustomerLabelLevelEnum getByType(String type) {
        return Stream.of(CustomerLabelLevelEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(NOT_LEVEL);
    }
}

