package com.youqian.api.enums.customer;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/11/26.
 */
@Getter
public enum CustomerSourceTypeEnum {

    MANAGE_IMPORT(0,"manageImport","系统导入","#66B4D7"),
    STORE(1,"store","店铺分享","#E24D53"),
    LIVE(2,"live","直播分享","#F6BC3F"),
    INSERT(3,"insert","手动添加","#425BBC"),
    GOODS(4,"goods","商品分享","#85C35D"),;

    private final Integer code;

    private final String  type;

    private final String  desc;

    private final String  color;

    CustomerSourceTypeEnum(Integer code, String type, String desc,String color) {
        this.code = code;
        this.type = type;
        this.desc = desc;
        this.color=color;
    }

    public static CustomerSourceTypeEnum getByCode(Integer code) {
        return Stream.of(CustomerSourceTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(MANAGE_IMPORT);
    }

    public static CustomerSourceTypeEnum getByType(String type) {
        return Stream.of(CustomerSourceTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(MANAGE_IMPORT);
    }
}