package com.youqian.api.enums.redpack;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 红包领取状态
 * Created by hong
 * time 2020/7/17.
 */
@Getter
public enum RedpackReceiveStatusEnum {

    UNACCALIMED((byte)0,"unaccalimed","未领取"),
    RECEIVING((byte)1,"receiving","领取中"),
    RECEIVED_SUCCESSFULLY((byte)2,"receivedSuccessfully","领取成功"),
    RECEIVE_FAILED((byte)3,"receiveFailed","领取失败");

    private final Byte code;

    private final String type;

    private final String desc;

    RedpackReceiveStatusEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static RedpackReceiveStatusEnum getByCode(Byte code) {
        return Stream.of(RedpackReceiveStatusEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(UNACCALIMED);
    }

    public static RedpackReceiveStatusEnum getByType(String type) {
        return Stream.of(RedpackReceiveStatusEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(UNACCALIMED);
    }
}

