package com.youqian.api.params.customer;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/11/23.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ActiveCustomerParam {

    /**
     * 查询客户什么时候添加的开始时间
     */
    private Date startDate;

    /**
     * 查询客户什么时候添加的结束时间
     */
    private Date endDate;

    /**
     * 商户id
     */
    private Long merchantId;

    /**
     * 员工id
     */
    private List<Long> employeeIds;

    /**
     * 查询客户什么时候互动的开始时间
     */
    private Date interactionStartDate;

    /**
     * 查询客户什么时候互动的结束时间
     */
    private Date interactionEndDate;
}
