package com.youqian.api.params.page;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/13.
 */
@Data
public class ModifyComponentParam implements Serializable {

    private static final long serialVersionUID = 1624392462524509029L;

    /**
     * 组件id
     * not null default = null
     */
    private Long componentId;

    /**
     * 组件名
     * max length = 50
     * not null default = null
     */
    private String componentName;

    /**
     * 组件等级 1父组件 2子组件
     * not null default = 1
     */
    private Integer componentLevel;

    /**
     * 父组件id
     * not null default = 0
     */
    private Long parentComponentId;

    /**
     * 组件设计图
     * max length = 255
     */
    private String designImgOss;

    /**
     * 组件作用页面
     */
    private List<Long> pageIds;

    /**
     * 组件别名
     * max length = 100
     * not null default = null
     */
    private String componentAlias;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;
}
