package com.youqian.api.params.page;

import lombok.Data;

import java.io.Serializable;

/**
 * Created by hong
 * time 2020/10/13.
 */
@Data
public class ModifyPageParam implements Serializable {

    private static final long serialVersionUID = 6498023725716446571L;

    /**
     * 唯一id
     * not null default = null
     */
    private Long pageId;

    /**
     * 页面名
     * max length = 30
     * not null default = null
     */
    private String pageName;

    /**
     * 是否支持组件化
     * not null default = 0
     */
    private Byte supportComponents;

    /**
     * 组件别名
     * max length = 100
     * not null default = null
     */
    private String pageAlias;

    /**
     * 对应页面路由
     * max length = 255
     * not null default = null
     */
    private String pageRoute;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;
}
