package com.youqian.api.params.statistics;

import cn.com.duiba.wolf.utils.DateUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

/**
 * Created by hong
 * time 2020/11/17.
 */
@Data
public class PlatformStatisticsParam implements Serializable {

    private static final long serialVersionUID = 8922706664161803713L;

    /**
     * 时间
     * 1 今天
     * 2 昨天
     * 3 本周
     * 4 本月
     */
    private Integer queryTimeType;

    /**
     * 商户id
     */
    private Long merchantId;

    /**
     * 年份
     */
    @Deprecated
    private Integer year=0;

    /**
     * 月份
     */
    @Deprecated
    private Integer month=0;

    /**
     * 日期
     */
    @Deprecated
    private Integer day=0;

    /**
     * 第几周
     */
    @Deprecated
    private Integer week=0;

    public void setQueryTimeType(Integer queryTimeType) {
        Date date = new Date();
        if(Objects.equals(4,queryTimeType)){
            this.year= getYears(date);
            this.month = getMonths(date);
            this.day =0;
            this.week =0;
            this.queryTimeType = queryTimeType;
        }else if(Objects.equals(2,queryTimeType)){
            this.year= getYears(DateUtils.daysAddOrSub(date,-1));
            this.month = getMonths(DateUtils.daysAddOrSub(date,-1));
            this.day=getDays(DateUtils.daysAddOrSub(date,-1));
            this.week=getWeeks(DateUtils.daysAddOrSub(date,-1));
            this.queryTimeType = queryTimeType;
        }else if(Objects.equals(3,queryTimeType)){
            this.year= getYears(date);
            this.month = 0;
            this.day = 0;
            this.week=getWeeks(date);
            this.queryTimeType = queryTimeType;
        }else if(Objects.equals(1,queryTimeType)){
            this.year= getYears(date);
            this.month = getMonths(date);
            this.day=getDays(date);
            this.week=getWeeks(date);
            this.queryTimeType = queryTimeType;
        }
    }

    private int getYears(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.YEAR);
    }

    private int getMonths(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.MONTH)+1;
    }

    private int getDays(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.DAY_OF_MONTH);
    }

    private int getWeeks(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.WEEK_OF_YEAR);
    }
}
