package com.youqian.api.params.wms.sonnodes;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class OrderSkuParam {
    /**
     * 商品sku编号
     */
    @NotNull(message = "商品明细编号不能为空")
    private long skuId;

    /**
     * 商品sku名称
     */
    @NotBlank(message = "商品明细名称不能为空")
    private  String skuName;

    /**
     * 商品sku下件规集合
     */
    @Valid
    @NotEmpty(message = "明细商品件规数量不能为空")
    private List<OrderDozenParam> dozenList;

}
