package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.customer.CustomerIntentExtDetail;
import com.youqian.api.dto.customer.CustomerIntentExtDto;
import com.youqian.api.response.ClueCount;

import java.util.List;

/**
 * @author tengtuox
 * @date 2021/1/11
 * @description
 */
@AdvancedFeignClient
public interface RemoteClueService {

    /**
     * 线索数量
     *
     * @param liveRoomIds liveRoomIds
     * @return ClueCount
     */
    List<ClueCount> clueCount(List<Long> liveRoomIds);

    /**
     * 返回最新的一条询价线索
     *
     * @param liveRoomId liveRoomId
     * @param userId userId
     * @return 没有询价时返回为null
     */
    CustomerIntentExtDetail newestIntent(Long liveRoomId, Long userId);
}
