package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.PageDto;
import com.youqian.api.dto.statistics.platform.CustomerStatisticsDto;
import com.youqian.api.dto.statistics.platform.EmployeeCustomerDto;
import com.youqian.api.dto.statistics.platform.PlatformStatisticsDto;
import com.youqian.api.dto.statistics.platform.custom.CustomerSourceDto;
import com.youqian.api.dto.statistics.platform.custom.MerchantPlatformStatisticsDto;
import com.youqian.api.params.statistics.ChartStatisticsParam;
import com.youqian.api.params.statistics.EmployeeCustomerStatisticsParam;
import com.youqian.api.params.statistics.PlatformMerchantStatisticsParam;
import com.youqian.api.params.statistics.PlatformStatisticsParam;

import java.util.List;

/**
 * 平台统计
 * Created by hong
 * time 2020/11/12.
 */
@AdvancedFeignClient
public interface RemotePlatformStatisticsService {
    /**
     * 按天统计平台数据任务
     */
    void platformStatisticsJob();

    /**
     * 平台数据统计
     */
    PlatformStatisticsDto platformStatistics(PlatformStatisticsParam platformStatisticsParam);

    /**
     * 平台商户数据统计
     */
    PageDto<MerchantPlatformStatisticsDto> platformMerchantStatistics(PlatformMerchantStatisticsParam platformMerchantStatisticsParam);

    /**
     * 直播邀约图表
     */
    String liveInvitationChart(ChartStatisticsParam chartStatisticsParam);

    /**
     * 直播时长图表
     */
    String liveDurationChart(ChartStatisticsParam chartStatisticsParam);

    /**
     * 客户图表
     */
    String customerChart(ChartStatisticsParam chartStatisticsParam);

    /**
     * 员工客户列表
     */
    PageDto<EmployeeCustomerDto> employeeCustomerList(EmployeeCustomerStatisticsParam employeeCustomerStatisticsParam);

    /**
     * 员工客户详情
     */
    List<CustomerSourceDto> employeeCustomerInfo(EmployeeCustomerStatisticsParam employeeCustomerStatisticsParam);

    /**
     * 客户统计
     */
    CustomerStatisticsDto customerStatistics(ChartStatisticsParam chartStatisticsParam);
}
