package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/8
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderMoneyBackPageRequest extends PageRequest implements Serializable {

    @ApiModelProperty("操作人（前端忽略）")
    private Long operatorUserId;

    @ApiModelProperty("操作商户（前端忽略）")
    private Long operatorMerchantId;

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "订单ID", required = true)
    private Long orderId;

}
