package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description 部门列表
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrgListRequest extends Operator implements Serializable {

    @PositiveOrZero(message = "上级组织ID必须大于等于0")
    @NotNull(message = "上级组织ID不能为空")
    @ApiModelProperty(value = "上级组织ID", required = true)
    private Long parentOrgId;

}
