package com.youqian.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author tengtuox
 * @date 2020/10/29
 * @description
 */
@Data
public class PassMerchantApplyRequest implements Serializable {

    /**
     * 申请ID
     */
    @Min(value = 1, message = "申请ID必须大于0")
    @NotNull(message = "申请ID不能为空")
    private Long merchantApplyId;

    /**
     * 商户名称
     */
    @NotBlank(message = "商户名称不能为空")
    private String merchantName;

    /**
     * 商户昵称
     */
    private String merchantNickName;

    /**
     * 客户名称
     */
    @NotBlank(message = "客户名称不能为空")
    private String customerName;

    /**
     * 客户手机号码
     */
    @NotBlank(message = "客户手机号码不能为空")
    private String customerMobile;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区编码
     */
    private String areaCode;

    /**
     * 完整地址
     */
    private String detailArea;

    /**
     * 页面模板类别id
     */
    @Min(value = 1, message = "页面模板类别必须大于0")
    @NotNull(message = "页面模板类别不能为空")
    private Long pageCategoryId;

    /**
     * 商品类别 1：一元商品  2：二元商品
     */
    @Min(value = 1, message = "商品类别必须大于0")
    @NotNull(message = "商品类别不能为空")
    private Integer goodsType;

    /**
     * 服务期开始时间
     */
    @NotNull(message = "服务期开始时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date startDate;

    /**
     * 服务期结束时间
     */
    @NotNull(message = "服务期结束时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date expireDate;

    /**
     * 负责人用户ID
     */
    private Long ownerUserId;

}
