package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tengtuox
 * @date 2020/9/22
 * @description
 */
@Data
public class OrderEmpStatisticsResult implements Serializable {

    @ApiModelProperty("员工ID")
    private Long employeeId;

    @ApiModelProperty("开单人")
    private String createUserName = "未知";

    @ApiModelProperty("开单数量")
    private Integer openOrderCount = 0;

    @ApiModelProperty("开单金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal openOrderMoney = BigDecimal.ZERO;

    @ApiModelProperty("发货数量")
    private Integer deliveryCount = 0;

    @ApiModelProperty("发货金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal deliveryMoney = BigDecimal.ZERO;

    @ApiModelProperty("待收款金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal restMoney = BigDecimal.ZERO;

    @ApiModelProperty("已收款金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal moneyBack = BigDecimal.ZERO;

}
