package com.youqian.api.response.wms;

import lombok.Data;

import java.util.Date;

@Data
public class WmsOrderFlowResult {



    /**
     * 商品库存流转编号
     * not null default = 0
     */
    private Long wmsOrderFlowId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;



    /**
     * 流转类型 1-入库 2-预定库存 4-预定退货 8-出库  16-盘点
     * not null default = null
     */
    private Byte flowType;

    /**
     * 流转数量
     * not null default = 0
     */
    private Integer flowQuantity;

    /**
     * 流转单号 入库单号 出库订单号 盘点编号
     * max length = 20
     * not null default = null
     */
    private String flowOrderNo;

//    /**
//     * 流转单号 orderId
//     * max length = 20
//     * not null default = null
//     */
//    private Long flowOrderId;

    /**
     * 流转单数据库编号
     * not null default = null
     */
    private Long wmsOrderId;



    /**
     * 操作人名称
     * max length = 50
     * not null default = 0
     */
    private String employeeName;



    /**
     * 备注
     * max length = 200
     * not null default =
     */
    private String comment;

    private String jssonStr;

}
