package com.youqian.api.dto.employee;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 直播间员工关系表
 * @author youqian mybatis generator 
 * 2020-12-17
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveRoomEmployeeRDto implements Serializable {
    private static final long serialVersionUID = 16081872324687789L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long liveRoomEmployeeRId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 直播间id
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 员工id
     * not null default = 0
     */
    private Long employeeId;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 是否首次进入直播前落地页
     * not null default = 0
     */
    private Byte firstIntoLiveBefore;
}