package com.youqian.api.dto.merchant;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 商户
 * @author youqian mybatis generator 
 * 2020-03-31
 */
@Data
public class MerchantDto implements Serializable {
    private static final long serialVersionUID = 15856574218913353L;

    /**
     * 自增键
     * not null default = null
     */
    private Long id;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 商户名称
     * max length = 20
     * not null default = 
     */
    private String merchantName;

    /**
     * 商户别名（代号）
     * max length = 10
     * not null default = 
     */
    private String merchantNickname;

    /**
     * 商户LOGO
     * max length = 100
     * not null default = 
     */
    private String logo;

    /**
     * 省编码
     * max length = 2
     * not null default = 
     */
    private String provinceCode;

    /**
     * 市编码
     * max length = 4
     * not null default = 
     */
    private String cityCode;

    /**
     * 区编码
     * max length = 6
     * not null default = 
     */
    private String areaCode;

    /**
     * 剩余合同数量
     * not null default = 0
     */
    private Integer remainContract;

    /**
     * 总共合同数量
     * not null default = 0
     */
    private Integer totalContract;

    /**
     * 服务期开始时间
     */
    private Date startDate;

    /**
     * 过期时间
     */
    private Date expireDate;

    /**
     * 状态/0-正常，1-停用
     * not null default = 0
     */
    private Byte merchantStatus;

    /**
     * 签约主体个数
     * not null default = 0
     */
    private Integer signEntityCount;

    /**
     * 联系电话
     * max length = 20
     * not null default = 
     */
    private String contactMobile;

    /**
     * 联系人姓名
     * max length = 20
     * not null default = 
     */
    private String contactName;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 创建人/申请人
     * not null default = 0
     */
    private Long createUserId;
    /**
     * 开单量
     */
    private Integer orderCount = 0;
    /**
     * 客户数
     */
    private Integer customerCount = 0;
    /**
     * 访问量
     */
    private Integer followCount = 0;

    /**
     * 商户订单唯一代码
     * not null default =
     */
    private String orderCode;

    /**
     * 页面模板类别id
     * not null default = 0
     */
    private Long pageCategoryId;

    /**
     * 商户负责人
     */
    private Long ownerUserId;

    /**
     * 商品类别 1：一元商品  2：二元商品
     * not null default = 0
     */
    private Integer goodsType;

    /**
     * 测试商户
     */
    private Byte merchantTest;

    /**
     * 销售员工ID
     */
    private Long sellerEmployeeId;

    /**
     * 销售员工名称
     */
    private String sellerEmployeeName;

    /**
     * 销售商户名称
     */
    private String sellerMerchantName;

    /**
     * 首页配置id
     */
    private Long homeConfigId;

    /**
     * 商户类型 null,0-  服装类企业  1-旅游类企业
     */
    private Byte type;
}