package com.youqian.api.dto.merchant;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 店铺
 * @author youqian mybatis generator 
 * 2020-04-02
 */
@Data
public class MerchantStoreDto implements Serializable {
    private static final long serialVersionUID = 15858182217127280L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 商户店铺ID
     * not null default = 0
     */
    private Long storeId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 店铺LOGO
     * max length = 100
     * not null default = 
     */
    private String logo;

    /**
     * 店铺名称
     * max length = 20
     * not null default = 
     */
    private String merchantName;

    /**
     * 店铺描述
     * max length = 100
     * not null default = 
     */
    private String description;

    /**
     * 商铺联系电话
     * max length = 20
     * not null default = 
     */
    private String mobile;

    /**
     * 商铺地址
     * max length = 150
     * not null default = 
     */
    private String address;

    /**
     * 经度
     * not null default = 0.0000000
     */
    private BigDecimal longitude;

    /**
     * 纬度
     * not null default = 0.0000000
     */
    private BigDecimal latitude;

    /**
     * 营业执照
     * max length = 50
     * not null default = 
     */
    private String regCode;

    /**
     * 法人
     * max length = 20
     * not null default = 
     */
    private String legalPerson;

    /**
     * 注册资金
     * max length = 10
     * not null default = 
     */
    private String registerMoney;

    /**
     * 老板头像
     * max length = 100
     * not null default = 
     */
    private String bossAvatarUrl;

    /**
     * 老板简介
     * max length = 40
     * not null default = 
     */
    private String bossDesc;

    /**
     * 老板寄语
     * max length = 200
     * not null default = 
     */
    private String bossRemarks;

    /**
     * 老板语音
     * max length = 200
     * not null default = 
     */
    private String bossVoice;

    /**
     * 公司成立时间
     * not null default = null
     */
    private Date establishmentDate;

    /**
     * 直播房间号
     * max length = 20
     * not null default = 
     */
    private String studioRoomNo;

    /**
     * 直播房间名
     * max length = 20
     * not null default = 
     */
    private String studioRoomName;

    /**
     * 直播状态
     * not null default = 0
     */
    private Byte studioRoomStatus;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 省编码
     * max length = 2
     * not null default = 
     */
    private String provinceCode;

    /**
     * 市编码
     * max length = 4
     * not null default = 
     */
    private String cityCode;

    /**
     * 区编码
     * max length = 6
     * not null default = 
     */
    private String areaCode;

    /**
     * 是否测试商户
     */
    private Byte test;

    /**
     * 职务
     */
    private String linkmanJob;

    /**
     * 微信二维码
     */
    private String linkmanQrcode;

    /**
     * 店铺公告
     */
    private String merchantNotice;
}