package com.youqian.api.dto.page;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 页面组件表
 * @author youqian mybatis generator 
 * 2020-10-16
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PageComponentDto implements Serializable {
    private static final long serialVersionUID = 16028286890033675L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long componentId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 组件名
     * max length = 50
     * not null default = null
     */
    private String componentName;

    /**
     * 组件等级 1父组件 2子组件
     * not null default = 1
     */
    private Integer componentLevel;

    /**
     * 父组件id
     * not null default = 0
     */
    private Long parentComponentId;

    /**
     * 组件设计图
     * max length = 255
     */
    private String designImgOss;

    /**
     * 组件别名
     * max length = 100
     * not null default = null
     */
    private String componentAlias;
}