package com.youqian.api.dto.reportmain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 报价商品规格表
 * @author youqian mybatis generator 
 * 2020-06-11
 */
@Data
public class OrderReportBillExtDto implements Serializable {
    private static final long serialVersionUID = 15918412279238667L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 报价ID
     * not null default = 0
     */
    private Long orderReportBillExtId;

    /**
     * 报价单ID
     * not null default = 0
     */
    private Long orderReportBillId;

    /**
     * 商品ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 商户规格ID
     * not null default = 0
     */
    private Long skuId;

    /**
     * 总数量
     * not null default = 0
     */
    private Integer goodsNum;

    /**
     * 删除标识
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 颜色
     */
    private String color;

    /**
     * 规格
     */
    private String size;

    /**
     * 件数
     */
    private Integer realGoodsNum;

    /**
     * 价格
     */
    private BigDecimal price;
}