package com.youqian.api.dto.shopgoods.custom;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/23.
 */
@Data
public class SkuDto implements Serializable {

    private static final long serialVersionUID = 1067163670263375625L;

    /**
     * skuId
     * not null default = null
     */
    private Long shopGoodsSkuId;

    /**
     * 库存
     */
    private Integer total;

    /**
     * 名称
     * max length = 100
     */
    private String name;

    /**
     * 商品规格码
     * max length = 255
     */
    private String goodsSpecCode;

    /**
     * 价格
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal price;

    /**
     * 件规
     */
    private Integer totalSpec;

    /**
     * 规格集合
     */
    private List<SkuSpecDto> specs=new ArrayList<>();

    /**
     * 是否选中
     */
    private Boolean selected=Boolean.FALSE;

    /**
     * 是否被修改
     */
    private Boolean modified=Boolean.FALSE;

    /**
     * 标志
     */
    private String flag;

    //////////////////旅游商品补充

    /**
     * 库存数量
     */
    private Integer stockQuantity;

    /**
     * 已售数量
     */
    private Integer saledQuantity;

    /**
     * 计划数量
     */
    private Integer planQuantity;

    /**
     * 库存位
     */
    private Integer placeNum;

    /**
     * 销售价格
     */
    private BigDecimal salePrice;

    /**
     * 市场价格
     */
    private BigDecimal marketPrice;

    /**
     * 有截止日期的情况
     */
    private Date expireDate;

    /**
     * 返佣方式
     */
    private Byte returnType;

    /**
     * 返佣金额
     */
    private BigDecimal returnMoney;
}
