package com.youqian.api.dto.shopgoods.custom.back;

import com.youqian.api.dto.shopgoods.ShopGoodsTagDto;
import com.youqian.api.dto.shopgoods.custom.SkuDto;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/27.
 */
@Data
public class GoodsAndSkuBackDto implements Serializable {

    private static final long serialVersionUID = -4594357716362965488L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopGoodsId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 商品类型
     */
    private Integer type;

    /**
     * 显示排序
     */
    private Long displayOrder;

    /**
     * 商品名称
     * max length = 50
     */
    private String name;

    /**
     * 商品短名称
     * max length = 20
     */
    private String shortName;

    /**
     * 商品图oss
     * max length = 100
     */
    private String thumb;

    /**
     * 商品单位
     * max length = 10
     */
    private String unit;

    /**
     * 商品详情
     * max length = 255
     */
    private String content;

    /**
     * 商品描述
     * max length = 255
     */
    private String description;

    /**
     * 商品编号
     * max length = 255
     */
    private String goodsSn;

    /**
     * 商品原价
     */
    private BigDecimal productPrice;

    /**
     * 商品现价
     */
    private BigDecimal marketPrice;

    /**
     * 商品成本
     */
    private BigDecimal costPrice;

    /**
     * 商品库存
     */
    private Integer total;

    /**
     * 显示库存 1显示 0 不显示
     */
    private Byte showTotal;

    /**
     * 减库存方式 0 拍下减库存 1 付款减库存 2 永不减库存
     */
    private Integer totalCnf;

    /**
     * 已售出数
     */
    private Integer sales;

    /**
     * 实际售出数
     */
    private Integer salesReal;

    /**
     * 是否上新 1是
     */
    private Byte newPublish;

    /**
     * 是否热卖  1是
     */
    private Byte hot;

    /**
     * 是否促销   1是
     */
    private Byte discount;

    /**
     * 是否推荐  1是
     */
    private Byte recommand;

    /**
     * 商户id
     */
    private Long merchId;

    /**
     * 规格数量
     */
    private Integer skuCount;

    /**
     * 颜色种类
     */
    private Integer colorCount;

    /**
     * 尺寸种类
     */
    private Integer sizeCount;

    /**
     * 图片总数
     */
    private Integer goodsPicCount;

    /**
     * sku
     */
    private List<SkuDto> skuDtos;

    /**
     * 商品标签集合
     */
    private List<ShopGoodsTagDto> shopGoodsTagDtos;

    /**
     * 是否需要二次预约
     */
    private byte needOrder;

    /**
     * 有截止日期的情况 sku的描述，可为空
     */
    private Date expireDate;
}
