package com.youqian.api.dto.statistics.platform;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created by hong
 * time 2020/11/22.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CustomerStatisticsDto implements Serializable {

    private static final long serialVersionUID = -612056468602954309L;

    /**
     * 新增客户数
     * not null default = 0
     */
    private Long newCustomers;

    /**
     * 客户总数
     * not null default = 0
     */
    private Long customerCount;

    /**
     * 活跃买家
     * not null default = 0
     */
    private Long activeCustomer;

    /**
     * 上月新增客户数
     * not null default = 0
     */
    private Long lastMonthNewCustomers;

    /**
     * 上月活跃买家
     * not null default = 0
     */
    private Long lastMonthActiveCustomer;

    /**
     * 上月本月新增客户增长百分比
     * not null default = 0
     */
    private BigDecimal newCustomersPercentage;

    /**
     * 上月本月活跃买家百分比
     * not null default = 0
     */
    private BigDecimal activeCustomersPercentage;


}
