package com.youqian.api.dto.survey;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 问卷排除表
 * @author youqian mybatis generator 
 * 2021-01-20
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SurveyExcludeDto implements Serializable {
    private static final long serialVersionUID = 16111360587367790L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long surveyExcludeId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 问卷id
     * not null default = 0
     */
    private Long surveyId;
}