package com.youqian.api.dto.wms;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 商品库存进出流水明细
 * @author youqian mybatis generator 
 * 2020-10-26
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WmsFlowDetailDto implements Serializable {
    private static final long serialVersionUID = 16037007112465905L;

    /**
     * 自动增长编号
     * not null default = null
     */
    private Long id;

    /**
     * 库存自动流转明细编号
     * not null default = null
     */
    private Long wmsFlowDetailId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 删除表示 0-正常 1-删除
     * not null default = null
     */
    private Boolean deleted;

    /**
     * 流转类型 1-入库 2-预定库存 4-预定退货 8-出库  16-盘点
     * not null default = 0
     */
    private Boolean flowType;

    /**
     * sku编号
     * not null default = 0
     */
    private Long shopGoodsSkuId;

    /**
     * 流转数量
     * not null default = 0
     */
    private Integer flowQuantity;

    /**
     * 件规编号
     * not null default = null
     */
    private Long dozenId;

    /**
     * 商品库存流转编号
     * not null default = 0
     */
    private Long wmsOrderFlowId;
}