package com.youqian.api.dto.wms;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 商品出入库单商品明细
 * @author youqian mybatis generator 
 * 2020-10-26
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WmsOrderDetailDto implements Serializable {
    private static final long serialVersionUID = 16037007112439362L;

    /**
     * 自动增长编号
     * not null default = null
     */
    private Long id;

    /**
     * 出入库明细单编号
     * not null default = null
     */
    private Long wmsOrderDetailId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 删除表示 0-正常 1-删除
     * not null default = null
     */
    private Boolean deleted;

    /**
     * 流转类型 1-入库 2-预定库存 4-预定退货 8-出库  16-盘点
     * not null default = null
     */
    private Byte flowType;

    /**
     * 商品编号
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 商品名称
     * max length = 50
     * not null default = null
     */
    private String goodsName;

    /**
     * 商品数量
     * not null default = 0
     */
    private Integer goodsQuantity;

    /**
     * 商品出入库单编号
     * not null default = 0
     */
    private Long wmsOrderId;
}