package com.youqian.api.enums;

import lombok.Getter;

/**
 * 深度访问标签
 * @author xiachenhang
 */
@Getter
public enum ActionTagEnum {
    NEW_ACCESS((byte)1,"#新访客"),
    DEPTH_ACCESS((byte)2,"#深度访问"),
    HAS_FOLLOW((byte)3,"#获得粉丝"),
    INTENTION_CUSTOMER((byte)4,"#意向客户");

    private byte code;
    private String type;

    ActionTagEnum(byte code,String type){
        this.code = code;
        this.type = type;
    }

    public static ActionTagEnum get(Byte code){
        if(code == null){
            return null;
        }
        for(ActionTagEnum actionTagEnum:values()){
            if(code == actionTagEnum.getCode()){
                return actionTagEnum;
            }
        }
        return null;
    }

}
