package com.youqian.api.params.goods;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.youqian.api.params.goods.spec.AddSkuSpecParamV1;
import com.youqian.api.params.goods.spec.UpdateSkuSpecParam;
import com.youqian.api.util.BigDecimalDeserializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/23.
 */
@Data
public class UpdateSkuParam implements Serializable {


    private static final long serialVersionUID = -8287799626840646588L;

    /**
     * skuId
     * not null default = null
     */
    private Long shopGoodsSkuId;

    /**
     * 库存
     */
    private Integer total;

    /**
     * 名称
     * max length = 100
     */
    private String name;

    /**
     * 商品规格码
     * max length = 255
     */
    private String goodsSpecCode;

    /**
     * 价格
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal price=BigDecimal.ZERO;

    /**
     * 件规
     */
    private Integer totalSpec;

    /**
     * 是否选中
     */
    private Boolean selected;

    /**
     * 规格集合
     */
    private List<UpdateSkuSpecParam> specs=new ArrayList<>();

    /**
     * 是否被修改
     */
    private Boolean modified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted=(byte)0;


    //////////////////旅游商品补充

    /**
     * 计划数量
     */
    private Integer planQuantity;

    /**
     * 库存位
     */
    private Integer placeNum;

    /**
     * 销售价格
     */
    private BigDecimal salePrice;

    /**
     * 市场价格
     */
    private BigDecimal marketPrice;

    /**
     * 有截止日期的情况
     */
    private Date expireDate;

    /**
     * 返佣方式
     */
    private Byte returnType;

    /**
     * 返佣金额
     */
    private BigDecimal returnMoney;

}
