package com.youqian.api.params.wms;

import com.youqian.api.request.PageRequest;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class FlowOrderParam extends PageRequest implements Serializable {

    /**
     * 关键词
     */
    private String keywords;


    /**
     * 商品ID
     */
    private Long goodsId;

    /**
     * 商品skuid
     * not null default = 0
     */
    private Long shopGoodsSkuId;

    /**
     * 商品出入库开始日期
     */
    private Date dayStartTime;

    /**
     * 商品出入库结束时间
     */
    private Date dayEndTime;


    /**
     * 商品出入库类型 0或不填为全部 1-入库 8-出库 16-盘点
     */
    private Byte flowType;


}
