package com.youqian.api.params.wms.sonnodes;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Data
public class OrderDozenParam {

    /**
     * 件规编号 如果为0 则要新增件规
     */
    @NotNull(message = "件规编号不能为空")
    @Min(value= 0,message = "新增件规编号为0")
    private long dozenId;

    /**
     * 本次操作件数
     */
    @NotNull(message = "件规商品数量不能为空")
    @Max(value= 99999999,message = "件规商品数量应在0-9999999之间")
    @Min(value= 0,message = "件规商品数量应在0-9999999之间")
    private int quantity;

    /**
     * 件规名称用户乘积计算
     */
    @NotBlank(message = "件规名称不能为空")
    private String dozenName;

}
