package com.youqian.api.params.wms.sonnodes;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class OrderGoodsParam {
    /**
     * 库存商品编号
     */
    @NotNull(message = "商品编号不能为空")
    private long goodsId;

    /**
     * 库存商品名称
     */
    @NotBlank(message = "商品名称不能为空")
    private String goodsName;

    /**
     * 库存商品sku集合
     */
    @Valid
    @NotEmpty(message = "进出库商品明细清单不能为空")
    private List<OrderSkuParam> skuList;
}
