package com.youqian.api.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class CustomerIntentDescRequest extends PageRequest {
    /**
     * 直播间ID
     */
    @NotNull(message = "直播间ID不能为空")
    private Long liveRoomId;

    /**
     * 筛选类型 1-待跟进 2-已跟进 3-已开单
     */
    private Integer type =0;
    /**
     * 用户ID-前端忽略
     */
    private Long userId;
    /**
     * 商户ID-前端忽略
     */
    private Long merchantId;

    /**
     * 客户ID-前端忽略
     */
    private List<Long> customerIds;
}
