package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/1/16
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ListCustomerAddressRequest extends Operator implements Serializable {

    @ApiModelProperty(value = "客户ID")
    private Long customerId;

    @NotNull(message = "地址类型不能为空")
    @Min(value = 1, message = "地址类型必须大于0")
    @ApiModelProperty(value = "地址类型，1-收货地址/2-提货地址", required = true)
    private Byte addressType;
}
