package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/11/23
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrgAddRequest extends Operator implements Serializable {

    @PositiveOrZero(message = "上级部门ID必须大于等于0")
    @NotNull(message = "上级部门ID不能为空")
    @ApiModelProperty(value = "上级部门ID", required = true)
    private Long parentOrgId;

    @NotBlank(message = "部门名称不能为空")
    @ApiModelProperty(value = "部门名称", required = true)
    private String orgName;
}
